
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{gfjournal}[2025/10/21 Gauge Freedom Journal class v0.2]

\DeclareOption{blinded}{\def\gf@blinded{1}}
\ProcessOptions\relax

\LoadClass[11pt]{article}

% Packages
\RequirePackage[margin=1in]{geometry}
\RequirePackage[T1]{fontenc}
\RequirePackage[utf8]{inputenc}
\RequirePackage{lmodern}
\RequirePackage{amsmath,amssymb,amsthm}
\RequirePackage{graphicx}
\RequirePackage{xcolor}
\RequirePackage{hyperref}
\RequirePackage{authblk}
\RequirePackage{enumitem}
\RequirePackage{titlesec}
\RequirePackage{etoolbox}
\RequirePackage{orcidlink}
\RequirePackage{doi}

% Hyperref setup
\hypersetup{
  colorlinks=true,
  linkcolor=blue,
  citecolor=blue,
  urlcolor=blue,
  pdftitle={Gauge Freedom Journal},
  pdfauthor={},
  pdfsubject={},
  pdfkeywords={}
}

% Journal logo (optional)
\newcommand{\journallogo}[1]{\def\gf@logo{#1}}
\providecommand{\gf@logo}{gauge_freedom_logo.png}
\newcommand{\gf@printlogo}{%
  \IfFileExists{\gf@logo}{\begin{center}\includegraphics[height=1.2cm]{\gf@logo}\end{center}\vspace{0.5em}}{}
}

% Title formatting
\titleformat{\section}{\large\bfseries}{\thesection}{0.6em}{}
\titleformat{\subsection}{\normalsize\bfseries}{\thesubsection}{0.6em}{}
\setcounter{secnumdepth}{3}

% Keywords
\newcommand{\keywords}[1]{\par\smallskip\noindent\textbf{Keywords—} #1\par\smallskip}

% Corresponding author
\newcommand{\correspondingauthor}[1]{\def\gf@corresponding{#1}}
\newcommand{\gf@printcorresponding}{%
  \ifcsdef{gf@corresponding}{\par\noindent\textit{Correspondence:} \gf@corresponding\par}{}}

% Declarations (optional)
\newcommand{\aicontributions}[1]{\def\gf@ai{#1}}
\newcommand{\artifactavailability}[1]{\def\gf@artifact{#1}}
\newcommand{\carstatement}[1]{\def\gf@car{#1}} % optional at launch
\newcommand{\reprochecklist}[1]{\def\gf@repro{#1}}
\newcommand{\conflicts}[1]{\def\gf@coi{#1}}
\newcommand{\funding}[1]{\def\gf@funding{#1}}
\newcommand{\ethics}[1]{\def\gf@ethics{#1}}
\newcommand{\energyfootprint}[1]{\def\gf@energy{#1}}
\newcommand{\acknowledgments}[1]{\def\gf@acks{#1}}

\newcommand{\printdeclarations}{%
  \clearpage
  \section*{Declarations}
  \ifdefined\gf@blinded\else
    \ifcsdef{gf@acks}{\subsection*{Acknowledgments}\gf@acks\par\medskip}{}\relax
  \fi
  \ifcsdef{gf@ai}{\subsection*{AI Contributions Statement}\gf@ai\par\medskip}{}\relax
  \ifcsdef{gf@artifact}{\subsection*{Artifact Availability}\gf@artifact\par\medskip}{}\relax
  \ifcsdef{gf@car}{\subsection*{Content-Addressable Receipts (optional)}\gf@car\par\medskip}{}\relax
  \ifcsdef{gf@repro}{\subsection*{Reproducibility Checklist}\gf@repro\par\medskip}{}\relax
  \ifcsdef{gf@energy}{\subsection*{Energy \& Carbon Disclosure}\gf@energy\par\medskip}{}\relax
  \ifcsdef{gf@coi}{\subsection*{Conflicts of Interest}\gf@coi\par\medskip}{}\relax
  \ifcsdef{gf@funding}{\subsection*{Funding}\gf@funding\par\medskip}{}\relax
  \ifcsdef{gf@ethics}{\subsection*{Ethics}\gf@ethics\par\medskip}{}\relax
}

% Author/affiliation formatting and blinded handling
\renewcommand\Authfont{\large}
\renewcommand\Affilfont{\normalsize\normalfont}
\setlength{\affilsep}{0.5em}

\newcommand{\gfmaketitle}{%
  \maketitle
  \vspace{-0.5em}%
  \gf@printlogo
  \gf@printcorresponding
  \bigskip\hrule\bigskip
}


% If blinded, suppress author block
\ifdefined\gf@blinded
  \renewcommand\maketitle{%
    \begin{center}
      {\LARGE\bfseries \@title \par}
      \vspace{0.7em}
      {\large Anonymous Submission to Gauge Freedom Journal\par}
      \vspace{0.7em}
      \date{}%
    \end{center}
  }
\fi
