# Gauge Freedom Journal — LaTeX Template (v0.3)

This package provides a minimal author template for **Gauge Freedom Journal** with:
- Double-blind support (`blinded` option).
- Optional declarations:
  AI Contributions, Artifact Availability, CAR statement,
  Repro Checklist, Energy/CO₂, COI, Funding, Ethics.
- Convenience macros: `\keywords{}`, `\correspondingauthor{}`.
- Optional **journal logo** at the top (`gauge_freedom_logo.png` by default).
- Optional **publication metadata macros** for Editorial Office use:
  `\articlecategory{}`, `\journalissue{}`, `\articledoi{}`, `\received{}`,
  `\accepted{}`, `\publishedonline{}`, `\copyrightyear{}`, `\license{}`.

## Files
- `gfjournal.cls` — journal class.
- `sample_full.tex` — camera-ready example.
- `sample_blinded.tex` — anonymous submission example.
- `checklists/repro_checklist.tex` — starter checklist include.
- `car/CAR.sample.json` — optional CAR stub for accepted works.
- `Makefile` — quick build targets.
- `references.bib` — biblatex example.

## Quick Start

```bash
make
# or individually:
latexmk -pdf sample_full.tex
latexmk -pdf -jobname=blinded sample_blinded.tex
````

### Logo

Place `gauge_freedom_logo.png` in the project root to show the journal logo above the title.
Or set a custom path:

```tex
\journallogo{path/to/your/logo.png}
```

### CARs (optional at launch)

CARs are **optional at launch (recommended)**.  
If you include one, place a `.json` file in the `car/` folder and reference it in the
Declarations section (see the commented examples in the samples).

GFJ follows a **standard-first** approach:  
use of Intelexta is welcome but not required. CAR-equivalent provenance methods are
acceptable if they provide comparable **human-readable summaries** and
**machine-verifiable audit trails**.

For high-stakes or AI-heavy claims, we strongly encourage attaching a CAR (or equivalent).



