
# Gauge Freedom Journal — LaTeX Template (v0.2)

This package provides a minimal author template for **Gauge Freedom Journal** with:
- Double-blind support (`blinded` option).
- Optional declarations (AI Contributions, Artifact Availability, CAR, Repro Checklist, Energy/CO₂, COI, Funding, Ethics).
- Convenience macros: `\keywords{}`, `\correspondingauthor{}`.
- Optional **logo** at the top (`gauge_freedom_logo.png` by default).

## Files
- `gfjournal.cls` — journal class.
- `sample_full.tex` — camera-ready example (no declarations shown by default).
- `sample_blinded.tex` — anonymous submission example.
- `checklists/repro_checklist.tex` — starter checklist include.
- `car/CAR.sample.json` — optional CAR stub for accepted works.
- `Makefile` — quick build targets.
- `references.bib` — biblatex example.

## Quick Start
```bash
latexmk -pdf sample_full.tex
# or for the blinded version
latexmk -pdf -jobname=blinded sample_blinded.tex
```

### Logo
Place `gauge_freedom_logo.png` in the project root to show the journal logo above the title. Or set a custom path:
```tex
\journallogo{path/to/your/logo.png}
```

### CARs (optional at launch)
CARs are **optional** at launch (recommended). If you include one, place a `.car.json` file in the `car/` folder and reference it in the Declarations section (commented template provided in the samples).
