
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{gfjournal}[2025/10/21 Gauge Freedom Journal class v0.2]

\DeclareOption{blinded}{\def\gf@blinded{1}}
\ProcessOptions\relax

\LoadClass[11pt]{article}

% Packages
\RequirePackage[margin=1in]{geometry}
\RequirePackage[T1]{fontenc}
\RequirePackage[utf8]{inputenc}
\RequirePackage{lmodern}
\RequirePackage{amsmath,amssymb,amsthm}
\RequirePackage{graphicx}
\RequirePackage{xcolor}
\RequirePackage{hyperref}
\RequirePackage{authblk}
\RequirePackage{enumitem}
\RequirePackage{titlesec}
\RequirePackage{etoolbox}
\RequirePackage{orcidlink}
\RequirePackage{doi}
\RequirePackage{fancyhdr}

\pagestyle{fancy}
\fancyhf{}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}

\AtBeginDocument{%
  \ifdefined\gf@blinded\else
    \ifcsdef{gf@issue}{%
      \fancyfoot[C]{\small\textit{Gauge Freedom Journal} \gf@issue}%
      \fancyfoot[R]{\small\thepage}%
    }{%
      \fancyfoot[R]{\small\thepage}%
    }%
  \fi
}



% Hyperref setup
\hypersetup{
  colorlinks=true,
  linkcolor=blue,
  citecolor=blue,
  urlcolor=blue,
  pdftitle={Gauge Freedom Journal},
  pdfauthor={},
  pdfsubject={},
  pdfkeywords={}
}

\date{} % default: no date printed

% Journal logo (optional)
\newcommand{\journallogo}[1]{\def\gf@logo{#1}}
\providecommand{\gf@logo}{gauge_freedom_logo.png}
\newcommand{\gf@printlogo}{%
  \IfFileExists{\gf@logo}{\begin{center}\includegraphics[height=0.8cm]{\gf@logo}\end{center}\vspace{0.5em}}{}
}

% Title formatting
\titleformat{\section}{\large\bfseries}{\thesection}{0.6em}{}
\titleformat{\subsection}{\normalsize\bfseries}{\thesubsection}{0.6em}{}
\setcounter{secnumdepth}{3}

% Keywords
\newcommand{\keywords}[1]{\par\smallskip\noindent\textbf{Keywords—} #1\par\smallskip}

% Corresponding author
\newcommand{\correspondingauthor}[1]{\def\gf@corresponding{#1}}
\newcommand{\gf@printcorresponding}{%
  \ifcsdef{gf@corresponding}{\par\noindent\textit{Correspondence:} \gf@corresponding\par}{}}

% Declarations (optional)
\newcommand{\aicontributions}[1]{\def\gf@ai{#1}}
\newcommand{\artifactavailability}[1]{\def\gf@artifact{#1}}
\newcommand{\carstatement}[1]{\def\gf@car{#1}}
\newcommand{\reprochecklist}[1]{\def\gf@repro{#1}}
\newcommand{\conflicts}[1]{\def\gf@coi{#1}}
\newcommand{\funding}[1]{\def\gf@funding{#1}}
\newcommand{\ethics}[1]{\def\gf@ethics{#1}}
\newcommand{\energyfootprint}[1]{\def\gf@energy{#1}}
\newcommand{\acknowledgments}[1]{\def\gf@acks{#1}}

\newcommand{\printdeclarations}{%
  \clearpage
  \section*{Declarations}
  % Acknowledgments: Only print if NOT blinded
  \ifdefined\gf@blinded
    % Blinded mode - skip acknowledgments
  \else
    \ifcsdef{gf@acks}{\subsection*{Acknowledgments}\gf@acks\par\medskip}{}\relax
  \fi
  % The rest are printed regardless of blinding
  \ifcsdef{gf@ai}{\subsection*{AI Contributions Statement}\gf@ai\par\medskip}{}\relax
  \ifcsdef{gf@artifact}{\subsection*{Artifact Availability}\gf@artifact\par\medskip}{}\relax
  \ifcsdef{gf@car}{\subsection*{Content-Addressable Receipts (optional)}\gf@car\par\medskip}{}\relax
  \ifcsdef{gf@repro}{\subsection*{Reproducibility Checklist}\gf@repro\par\medskip}{}\relax
  \ifcsdef{gf@energy}{\subsection*{Energy Disclosure}\gf@energy\par\medskip}{}\relax
  \ifcsdef{gf@coi}{\subsection*{Conflicts of Interest}\gf@coi\par\medskip}{}\relax
  \ifcsdef{gf@funding}{\subsection*{Funding}\gf@funding\par\medskip}{}\relax
  \ifcsdef{gf@ethics}{\subsection*{Ethics}\gf@ethics\par\medskip}{}\relax
}

% Author/affiliation formatting and blinded handling
\renewcommand\Authfont{\large}
\renewcommand\Affilfont{\normalsize\normalfont}
\setlength{\affilsep}{0.5em}


% --- Publication metadata (optional; typically set by Editorial Office) ---
\newcommand{\articlecategory}[1]{\def\gf@category{#1}} % e.g., RESEARCH, EDITORIAL
\newcommand{\journalissue}[1]{\def\gf@issue{#1}} % e.g., (2026) 56:4
\newcommand{\articledoi}[1]{\def\gf@articledoi{#1}}
\newcommand{\received}[1]{\def\gf@received{#1}}
\newcommand{\accepted}[1]{\def\gf@accepted{#1}}
\newcommand{\publishedonline}[1]{\def\gf@publishedonline{#1}}
\newcommand{\copyrightyear}[1]{\def\gf@copyrightyear{#1}}
\newcommand{\copyrightowner}[1]{\def\gf@copyrightowner{#1}} % default The Author(s)
\newcommand{\printpublishedonline}{\gf@printpublishedonline}
\newcommand{\license}[1]{\def\gf@license{#1}}
\providecommand{\gf@license}{CC BY 4.0}


\newcommand{\gf@printpubmeta}{%
  \ifdefined\gf@blinded\else
    \begingroup\small
    \begin{center}
      \ifcsdef{gf@category}{\textsc{\gf@category}\ }{}%
      \textsc{Gauge Freedom Journal}%
      \ifcsdef{gf@issue}{\ \gf@issue}{}%
      \par
      \ifcsdef{gf@articledoi}{%
        \href{https://doi.org/\gf@articledoi}{https://doi.org/\gf@articledoi}%
      }{}%
    \end{center}
    \endgroup
  \fi
}

\newcommand{\gf@printreceivedaccepted}{%
  \ifdefined\gf@blinded\else
    \ifcsdef{gf@received}{%
      \par\noindent\small
      \textit{Received:} \gf@received%
      \ifcsdef{gf@accepted}{ / \textit{Accepted:} \gf@accepted}{}%
      \par\normalsize
    }{}%
  \fi
}

\newcommand{\gf@printcopyright}{%
  \ifdefined\gf@blinded\else
    \ifcsdef{gf@copyrightyear}{%
      \par\noindent\small
      \textcopyright\ \gf@copyrightyear\ %
      \ifcsdef{gf@copyrightowner}{\gf@copyrightowner}{The Author(s)}%
      .\ %
      \ifcsdef{gf@license}{Licensed under \gf@license.}{}%
      \par\normalsize
    }{}%
  \fi
}

\newcommand{\gf@printpublishedonline}{%
  \ifdefined\gf@blinded\else
    \ifcsdef{gf@publishedonline}{%
      \par\noindent\small
      \textit{Published online:} \gf@publishedonline%
      \par\normalsize
    }{}%
  \fi
}



\newcommand{\gfmaketitle}{%
  \maketitle
  \vspace{-0.8em}
  \gf@printpubmeta
  \vspace{0.3em}
  \gf@printlogo
  \vspace{0.2em}
  \gf@printcorresponding
  \gf@printreceivedaccepted
  \gf@printpublishedonline
  \gf@printcopyright
  \medskip
  \noindent\rule{\linewidth}{0.4pt}
  \medskip
}



% If blinded, suppress author block
\ifdefined\gf@blinded
  \renewcommand\maketitle{%
    \begin{center}
      {\LARGE\bfseries \@title \par}
      \vspace{0.7em}
      {\large Anonymous Submission to Gauge Freedom Journal\par}
      \vspace{0.7em}
      \date{}%
    \end{center}
  }
\fi
